/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "ToolHVTFAd.h"

/*!
  \class ToolHVTFAd ToolHVTFAd.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ToolHVTFAd::ToolHVTFAd(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);

  freqSamp->setUnit(tr(" Hz"));
  freqSamp->setPrecision(2);
  freqSamp->setSingleStep(0.25);
  freqSamp->setAdmissibleRange(0.01, std::numeric_limits<double>::infinity());

  wavelet->morletFi->setToolTip(tr("This is just for computing the resolution in time and frequency. "
                                   "It has no influence on the computation of the Morlet transform."));
}

void ToolHVTFAd::getParameters(HVTFAParameters& param)
{
  TRACE;
  freqSamp->getParameters(param.frequencySampling());
  timeLimits->getParameters(param.timeRange());
  wavelet->getParameters(param.wavelet());
  param.setOutputDirectory(outputDirectory->text());
}

void ToolHVTFAd::setParameters(const HVTFAParameters& param)
{
  TRACE;
  freqSamp->setParameters(param.frequencySampling());
  timeLimits->setParameters(param.timeRange());
  wavelet->setParameters(param.wavelet());
  outputDirectory->setText(param.outputDirectory().absolutePath());
}

void ToolHVTFAd::on_outputDirectoryBut_clicked()
{
  TRACE;
  QString s=Message::getExistingDirectory(tr("H/V Time frequency Analysis output file"), tr("Output max files (*.max)"));
  if(s.length()>0) outputDirectory->setText(s);
}
