/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef READER_H
#define READER_H

#include <QGpCoreStat.h>

#include "Samples.h"

class Reader : public HistogramReader
{
public:
  Reader();
  ~Reader();

  enum Plot {Dispersion=1, Ellipticity=2, Noise=4, Azimuth=8, Power=16};
  Q_DECLARE_FLAGS(Plots, Plot);

  bool setOptions(int& argc, char ** argv);
  bool setDefaultLimits();

  bool isEmpty() const {return _samples->isEmpty();}

  static void helpY(ApplicationHelp * h);

  void setSamples(Samples * s) {_samples=s;}
  Samples * samples() {return _samples;}

  double relativeRange() const {return _relativeRange;}
  bool nullEllipticities() const {return _nullEll;}
  double noiseDeviation() const {return _noiseDev;}
  double slownessDeviation() const {return _slownessDev;}
  const QString& polarization() const {return _polarization;}

  const SamplingParameters& dispersionSampling() const {return _dispersionSampling;}
  const SamplingParameters& ellipticitySampling() const {return _ellipticitySampling;}
  const SamplingParameters& noiseSampling() const {return _noiseSampling;}
  const SamplingParameters& azimuthSampling() const {return _azimuthSampling;}
  const SamplingParameters& powerSampling() const {return _powerSampling;}

  const QString& dispersionTitle() const {return _dispersionTitle;}
  const QString& ellipticityTitle() const {return _ellipticityTitle;}
  const QString& noiseTitle() const {return _noiseTitle;}
  const QString& azimuthTitle() const {return _azimuthTitle;}
  const QString& powerTitle() const {return _powerTitle;}

  const QString& referenceDispersionLayer() const {return _referenceDispersionLayer;}
  const QString& referenceEllipticityLayer() const {return _referenceEllipticityLayer;}

  Plots showPlots() const {return _showPlots;}
protected:
  virtual bool loadSamples(QTextStream& s, const QString& lastLine);

  Plots _showPlots;
  union {
    struct {
      ManualFlags dispersion;
      ManualFlags ellipticity;
      ManualFlags noise;
      ManualFlags azimuth;
      ManualFlags power;
    };
    int flags[5];
  } _manual;
private:
  Samples * _samples;

  double _relativeRange;
  bool _nullEll;
  double _noiseDev;
  double _slownessDev;
  QString _polarization;

  int _dispersionColumn;
  int _ellipticityColumn;
  int _noiseColumn;
  int _azimuthColumn;
  int _powerColumn;
  SamplingParameters _dispersionSampling;
  SamplingParameters _ellipticitySampling;
  SamplingParameters _noiseSampling;
  SamplingParameters _azimuthSampling;
  SamplingParameters _powerSampling;
  QString _dispersionTitle;
  QString _ellipticityTitle;
  QString _noiseTitle;
  QString _azimuthTitle;
  QString _powerTitle;
  QString _referenceDispersionLayer;
  QString _referenceEllipticityLayer;
};

#endif // READER_H

