/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MODEWIDGETS_H
#define MODEWIDGETS_H

#include <QGpGuiMath.h>

#include "Samples.h"
#include "Reader.h"

class ModeWidgets : public QObject
{
  Q_OBJECT
public:
  ModeWidgets(QObject * parent=nullptr);
  ~ModeWidgets();

  void setCurveBrowser(CurveBrowser * c) {_curves=c;}

  void addWidgets(GraphicSheet * sheet, const Reader& param);
  void setSamples(const Samples& s, const Reader& param);
  void setLimits(bool normalize);
  void setComments(const QString& cmt);

  void setColorMap(const ColorMap& map);
private:
  void setHistogram(IrregularGrid2DPlot * layer, Histogram2D * hist, bool normalized);
  Histogram2D * histogram(const Reader& param, const SamplingParameters& y);
  Histogram2D * dispersionHistogram(const Samples& s, const Reader& param);
  Histogram2D * ellipticityHistogram(const Samples& s, const Reader& param);
  Histogram2D * noiseHistogram(const Samples& s, const Reader& param);
  Histogram2D * azimuthHistogram(const Samples& s, const Reader& param);
  Histogram2D * powerHistogram(const Samples& s, const Reader& param);
  void setLimits(IrregularGrid2DPlot * layer, bool normalize);

  CurveBrowser * _curves;
  QString _name;

  IrregularGrid2DPlot * _dispersion;
  IrregularGrid2DPlot * _ellipticity;
  IrregularGrid2DPlot * _noise;
  IrregularGrid2DPlot * _azimuth;
  IrregularGrid2DPlot * _power;
};

#endif // MODEWIDGETS_H

