/***************************************************************************
**
**  This file is part of gpsignal.
**
**  gpsignal is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpsignal is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-16
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALREADER_H
#define SIGNALREADER_H

#include <QGpCoreMath.h>

class Wavelet
{
public:
  Wavelet() {amplitude=1.0;
             frequency=1.0;
             phase=0.0;
             azimuth=0.0;
             velocity=0.0;}

  double amplitude;
  double frequency;
  double phase;
  double azimuth;
  double velocity;
};

class SignalReader : public ArgumentStdinReader
{
  TRANSLATIONS("SignalReader")
public:
  SignalReader();
  ~SignalReader();

  bool setOptions(int& argc, char ** argv);
  void exec();
protected:
  virtual bool parse(QTextStream& s);
private:
  bool addWavelet(int posIndex, const Point2D& pos,
                  const QString& buf);
  static double misfit(double ampPhi[]);

  int _nSamples;
  //double _commonFrequency;
  double _deltaT;
  double * _samples;
  double _timeLength;
  Curve<Point2D> * _dispersionCurve;
  Point2D _stationCoord;
  IrregularGrid2D _grid;
  //bool _uniqueFrequency;
  QVector<QVector<Wavelet>> _wavelets;
  bool _square;
};

#endif // SIGNALREADER_H
