/***************************************************************************
**
**  This file is part of gpparam2model.
**
**  gpparam2model is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpparam2model is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-06-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "ModelGenerator.h"

/*!
  \class ModelGenerator ModelGenerator.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ModelGenerator::ModelGenerator()
{
  _vp=0;
  _vs=0;
  _rho=0;
  _nu=0;
  _poissonCondition=0;
}

/*!
  Description of destructor still missing
*/
ModelGenerator::~ModelGenerator()
{
  // Poisson's condition deleted by parameter space
  // Profiles deleted by ground model
}

bool ModelGenerator::setParamSpace(ParamGroundModel * gm)
{
  TRACE;

  _paramModel=gm;
  _paramModel->initFinalProfiles();
  parameterSpace().clearParameters();
  if(!_paramModel->toParameters(parameterSpace())) return false;
  _vp=_paramModel->find("Vp");
  _vs=_paramModel->find("Vs");
  _rho=_paramModel->find("Rho");
  if(_vp && _vs) {
    _nu=_paramModel->find("Nu");
    ASSERT(_nu && _nu->type()==ParamProfile::Condition);
    _poissonCondition=new PoissonCondition(_vp, _vs, _nu);
    parameterSpace().addCondition(_poissonCondition);
  }
  return true;
}

AbstractForward * ModelGenerator::clone() const
{
  TRACE;
  ModelGenerator * forward=new ModelGenerator;
  forward->setParamSpace(new ParamGroundModel(*_paramModel));
  return forward;
}

double ModelGenerator::misfit(bool& ok)
{
  TRACE;
  Seismic1DModel * surfModel =
    DCReportBlock::surfaceWaveModel(_vp->resampledProfile().depths(),
                                    _vp->resampledProfile().values(),
                                    _vs->resampledProfile().values(),
                                    _rho->resampledProfile().values(),
                                    &_nu->minResampledProfile().values(),
                                    &_nu->maxResampledProfile().values());
  if( !surfModel->initCalculation()) {
    App::log(tr(" *** WARNING *** : bad physical model\n") );
    App::log(surfModel->toString()+"\n");
    ok=false;
  }
  QTextStream s(stdout);
  s << "#" << endl;
  surfModel->toStream(s);
  delete surfModel;
  return 0.0;
}
