/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODELSLIDER_H
#define MODELSLIDER_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

class ModelSlider : public QWidget, public XMLClass
{
  Q_OBJECT
public:
  ModelSlider(QWidget * parent=nullptr);
  ~ModelSlider();

  virtual const QString& xml_tagName() const {return xmlModelSliderTag;}
  static const QString xmlModelSliderTag;

  void setReferenceModel(GeophysicalModel * m);
  bool modify(GeophysicalModel * m, double p);

  void setTitle(const QString& t);
  QString title() const;

  void setCode(const QString& c);
  QString code() const {return _code;}
private slots:
  void edit();
  void sliderChanged();
signals:
  void modelChanged(GeophysicalModel * m);
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _code;
  QLabel * _titleWidget;
  QSlider * _sliderWidget;

  GeophysicalModel * _referenceModel;
  GeophysicalModel::GeophysicalContext * _codeContext;
  ExpressionActions _codeActions;
};

#endif // MODELSLIDER_H
