/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ToolTFA.h"
#include "TFAPlugin.h"

#include "geopsytfaInstallPath.h"
#include "geopsytfaVersion.h"
#include "GeopsyCoreVersion.h"

const char * TFAPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void TFAPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("Time frequency analysis"));
  a->setIcon(QIcon(":tfa-22x22.png"));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * TFAPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new ToolTFA(wsParent);
  default:
    return 0;
  }
}

PACKAGE_INFO("geopsytfa", GEOPSYTFA)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(geopsytfa, TFAPlugin)
#endif
