/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-03-15
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SpectrumSummary.h"

SpectrumSummary::SpectrumSummary(QWidget* parent)
    : AbstractSummary(parent)
{
  TRACE;
  Settings::getSize(this, "SpectrumSummary");
  setWindowTitle("Spectrum summary");
}

SpectrumSummary::~SpectrumSummary()
{
  TRACE;
  Settings::setSize(this, "SpectrumSummary");
}

void SpectrumSummary::setWindowTitle(QString subPoolName)
{
  TRACE;
  QWidget::setWindowTitle(tr("Spectrum summary - ")+subPoolName);
}

void SpectrumSummary::createGraphs(bool multiStations)
{
  TRACE;
  if(multiStations) {
    createStackedGraph(0.5, 0.0);
    createAverageGraph(9.5, 0.0);
    createSpectrumGridGraph(0.5, sheet()->printBottom());
    createBubbleGraph(0.5, sheet()->printBottom());
  } else {
    createStackedGraph(0.5, 0.0);
    createAverageGraph(9.5, 0.0);
  }
}

void SpectrumSummary::setValues(const QMap<double, CurveResults *> * dist2stat)
{
  TRACE;
  setStackedValues();
  setAverageValues();
  if(spectrumGridLayer()) {
    setSpectrumGridValues(dist2stat);
    setBubbleValues();
  }
}
