/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-29
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SpectrumRotateToolWidget.h"
#include "SpectrumRotateStation.h"
#include "SpectrumRotateResultSheet.h"

/*!
  \class SpectrumRotateToolWidget SpectrumRotateToolWidget.h
  \brief Brief description of class still missing

  Inherits ToolHV because the rotation requires 3 component signals and not just single individual
  signals like ToolSpectrum
*/

/*!
  Description of constructor still missing
*/
SpectrumRotateToolWidget::SpectrumRotateToolWidget(QWidget * parent)
    : AbstractHVWidget(parent)
{
  TRACE;
  setWindowIcon(QIcon(":spectrumrotate-22x22.png"));
  setObjectName("SpectrumRotateToolWidget");

  winParam->addComponent(tr("Any component"));

  removeHorizontalComponents();

  _tool=new SpectrumRotateTool(this);
}

bool SpectrumRotateToolWidget::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  if(!AbstractHVWidget::setSubPool(subPool)) {
    return false;
  }
  if(_winResults) {
    _winResults->setUnits(tr("Power spectral density [(%1)^2/Hz]"));
  }
  setWindowTitle(tr("Horizontal Spectrum Rotate toolbox - ")+subPool->name());
  return true;
}


AbstractResultSheet * SpectrumRotateToolWidget::createResultSheet()
{
  TRACE;
  return new SpectrumRotateResultSheet;
}

AbstractSummary * SpectrumRotateToolWidget::createSummary()
{
  TRACE;
  return nullptr;
}

