/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HVPLUGIN_H
#define HVPLUGIN_H

#include <GeopsyGui.h>

class TabHVPreferences;

class HVPlugin : public GeopsyGuiInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.geopsyInterface")
#endif
  Q_INTERFACES(GeopsyCore::GeopsyCoreInterface)
public:
  HVPlugin() {_tab=0;}

  QString tag() const {return "geopsyhv";}
  QString title() const {return tr("H/V and Spectal ratios");}

  void createToolActions(QObject * toolFactory);
  AbstractToolWidget * createTool(int id, QWidget * wsParent) const;

  void addPreferenceTab(QTabWidget * parent);
  void setPreferences();
  const char * interfaceVersion() const;
private:
  TabHVPreferences * _tab;
};

#endif // HVPLUGIN_H
