/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-14
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ToolDamping_H
#define ToolDamping_H

#include <GeopsyGui.h>

class ToolDampingd;

class ToolDamping :  public AbstractToolWidget
{
  Q_OBJECT
public:
  ToolDamping(QWidget * parent);

  virtual bool setSubPool(SubSignalPool * subPool);
private slots:
  void start();
protected:
  virtual void updateAllFields();
  virtual AbstractParameters * parameters(AbstractParameters * param=0) const;
  virtual void setParameters(const AbstractParameters * param);
  virtual bool initStations(SubSignalPool * subPool);
private:
  SubSignalPool * _subPool;
  ToolDampingd * _d;
};

#endif
