/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONCOORDINATES_H
#define STATIONCOORDINATES_H

#include <GeopsyGui.h>
#include <QGpGuiTools.h>

#include "ui_StationCoordinates.h"

class StationCoordinates : public Dialog, protected Ui::StationCoordinates
{
  Q_OBJECT
public:
  StationCoordinates(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~StationCoordinates();

  Point lookup(Signal * sig, bool & ok);
  const UtmZone& utmZone() const {return _utmZone;}

  bool init(SubSignalPool * subPool);
  void setReadOnly(bool ro) {buttonOk->setEnabled(!ro);}
private slots:
  void on_loadBut_clicked();
  void on_saveBut_clicked();
  void on_addBut_clicked();
  void on_relativePosBut_clicked();
protected:
  bool addStation(QString name, Point coord, bool force);
  virtual QString keyName(Signal * sig) {return sig->name();}
  virtual Point coordinates(Signal * sig) {return sig->receiver();}

  QList<NamedPoint> _stations;
private:
  void updateUtmZone();
  void beginMap();
  void endMap();
  StationCoordinatesItem * model();

  QMap<QString, int> * _map;
  UtmZone _utmZone;
};

#endif // STATIONCOORDINATES_H
