/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <qvariant.h>

#include <GeopsyCore.h>
#include "ExportFileType.h"

/*
 *  Constructs a ExportFileType_Base as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
ExportFileType::ExportFileType(QWidget *parent, Qt::WindowFlags f)
    : Dialog(parent, f)
{
  TRACE;
  setupUi(this);
}

void ExportFileType::updateAllFields()
{
  TRACE;
  maximumSignalsPerFileEdit->setEnabled(maximumSignalsPerFileBut->isChecked());
}

void ExportFileType::setFormatList(bool addTableFormat)
{
  TRACE;
  _formats=SignalFileFormat::exportList();
  if(addTableFormat) {
    _formats.append(QPair<QString, SignalFileFormat>(tr("Table"), SignalFileFormat::Temporary));
  }
  std::sort(_formats.begin(), _formats.end());
  int n=_formats.count();
  for(int i=0; i<n; i++) {
    type->addItem(_formats.at(i).first);
  }
}

SignalFileFormat ExportFileType::format() const
{
  TRACE;
  return _formats.at(type->currentIndex()).second;
}

bool ExportFileType::useOriginalBaseName() const
{
  TRACE;
  return useOriginalBaseNameBut->isChecked();
}

void ExportFileType::on_maximumSignalsPerFileBut_toggled(bool c)
{
  TRACE;
  maximumSignalsPerFileEdit->setEnabled(c);
}

int ExportFileType::maximumSignalsPerFile() const
{
  TRACE;
  return maximumSignalsPerFileBut->isChecked() ? maximumSignalsPerFileEdit->value() : 0;
}
