/***************************************************************************
**
**  This file is part of WaranCore.
**
**  WaranCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  WaranCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-01
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GPSBLOCK_H
#define GPSBLOCK_H

#include "WaranCoreDLLExport.h"

namespace WaranCore {

class GpsFix;

#define GPSBLOCK_VERSION 1

class WARANCORE_EXPORT GpsBlock
{
public:
  GpsBlock(const char * bytes);

  unsigned char index() const;
  unsigned char state() const;
  unsigned char totalSize() const;
  void decode(GpsFix& fix) const;

  static char * encode(unsigned char index, const GpsFix& oldFix,
                       const GpsFix& newdFix, unsigned int& byteCount);
private:
  static inline unsigned int encode(char *& ptr, unsigned char flagOffset, int oldValue, int newValue);
  static inline unsigned int encode(char *& ptr, unsigned char flagOffset, short oldValue, short newValue);
  static inline unsigned int encode(char *& ptr, unsigned char flagOffset, char oldValue, char newValue);

  static inline unsigned char size(unsigned int flags, unsigned char flagOffset);
  inline void decode(const char *& ptr, char size, int& value) const;
  inline void decode(const char *& ptr, char size, unsigned short& value) const;
  inline void decode(const char *& ptr, char size, unsigned char& value) const;
  enum Offsets {Longitude=10, Latitude=12, Altitude=14, HorizontalAccuracy=16,
                HorizontalDop=18, NorthingDop=20, EastingDop=22,
                SateliteCount=24};
  const char * _bytes;
  char _sizes[8];
};

} // namespace WaranCore

#endif // GPSBLOCK_H
