/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-11-19
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef POLARGRIDPLOT_H
#define POLARGRIDPLOT_H

#include <QGpCoreTools.h>

#include "GridPlot.h"

namespace SciFigs {

class SCIFIGS_EXPORT PolarGridPlot : public GridPlot
{
  Q_OBJECT
public:
  PolarGridPlot(AxisWindow * parent);
  ~PolarGridPlot();

  virtual bool mouseReleaseEvent (QMouseEvent * e, int);
signals:
  void clicked(double r, double phi);
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
private:
  void drawCircularGridLines(const LayerPainterRequest& lp, QPainter& p, Rect& limits) const;
  void grid2DPolarLimits(const LayerPainterRequest& lp, Rect& limits) const;
  void drawGrid2DPolarBlock(const LayerPainterRequest& lp, QPainter& p, const Rect& limits) const;

  Grid2D<double> * _theGrid;
};

} // namespace SciFigs

#endif // POLARGRIDPLOT_H
