/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-11
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LIVEGRIDLAYER_H
#define LIVEGRIDLAYER_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "IrregularGrid2DPlot.h"
#include "GridPlot.h"
#include "AutoAdjustScale.h"

namespace SciFigs {

  class SCIFIGS_EXPORT LiveGridLayer : public GridPlot, public AutoAdjustScale
  {
    Q_OBJECT
  public:
    LiveGridLayer(AxisWindow * parent);
    ~LiveGridLayer();

    enum Variables {CrossXY, InvCrossXY, CrossXZ, CrossYZ,
                    Value_XYMaxZ, Value_XZMaxY, Value_YZMaxX,
                    Z_XYMaxZ, Y_XZMaxY, X_YZMaxX,
                    GradXYDirection, GradXZDirection, GradYZDirection,
                    GradXYValue, GradXZValue, GradYZValue,
                    GradZvsXY,
                    ConcavityXY, ConcavityXZ, ConcavityYZ,
                    StepLengthXY, StepLengthXZ, StepLengthYZ,
                    StepDirectionXY, StepDirectionXZ, StepDirectionYZ,
                    StepX, StepY, StepZ
                   };

    virtual const QString& xml_tagName() const {return IrregularGrid2DPlot::xmlIrregularGrid2DPlotTag;}

    void setFunction(AbstractFunction * f);
    AbstractFunction * takeFunction();
    const AbstractFunction * function() const {return _function;}

    void setVariables(Variables v) {_variables=v;}
    Variables variables() const {return _variables;}

    void setFixedVariable(double v) {_fixedVariable=v;}
    double fixedVariable() const {return _fixedVariable;}

    void setValueFactor(double f) {_valueFactor=f;}
    double valueFactor() const {return _valueFactor;}

    void setSampling(int s) {_sampling=s;}
    int sampling() const {return _sampling;}

    virtual bool hasProperties() {return true;}
    virtual void addProperties(PropertyProxy * pp);
    virtual void removeProperties(PropertyProxy * pp);
    virtual void properties(PropertyWidget * w) const;
    virtual void setProperty(uint wid, int pid, QVariant val);

    virtual QString coordinateTipInfo(const Point2D&, const Point2D& pReal) const;
    virtual Rect boundingRect() const;
    double value(const Point2D& p) const;
  private slots:
    void showAdjustedPalette(const ColorMap& map);
  signals:
    void paletteAdjusted(const ColorMap& map) const;
  protected:
    virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;

    AbstractFunction * _function;
    int _sampling;
  private:
    IrregularGrid2D calculateGrid(const QSize& s, const GraphContentOptions& gc,
                                      const LayerPainterRequest * lp=nullptr) const;
    void adjustPalette(const IrregularGrid2D& grid, ColorMap& pal) const;

    double _fixedVariable;
    double _valueFactor;
    Variables _variables;
    static uint _tab;
  };

} // namespace SciFigs

#endif // LIVEGRIDLAYER_H
