/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>
#include "LineDelegate.h"
#include "LineItem.h"

namespace SciFigs {

/*!
  \class LineDelegate LineDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

QWidget * LineDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem & option,
                                         const QModelIndex &index) const
{
  TRACE;
  const LineItem * item=qobject_cast<const LineItem *>(index.model());
  ASSERT(item);

  switch (index.column()) {
  case 0: {
      return QItemDelegate::createEditor(parent, option, index);
    }
  default: {
      QLineEdit * w=new QLineEdit(parent);
      w->setAlignment(Qt::AlignRight);
      return w;
    }
  }
}

void LineDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
  TRACE;
  const LineItem * item=qobject_cast<const LineItem *>(index.model());
  ASSERT(item);

  switch (index.column()) {
  case 0:
    QItemDelegate::setEditorData(editor, index);
    break;
  default: {
      QLineEdit * w= qobject_cast<QLineEdit *>(editor);
      if (!w) return;
      w->setText(index.model()->data(index).toString());
      w->selectAll();
    }
    break;
  }
}

void LineDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
    const QModelIndex &index) const
{
  TRACE;
  const LineItem * item=qobject_cast<const LineItem *>(index.model());
  ASSERT(item);

  switch(index.column()) {
  case 0:
    QItemDelegate::setModelData(editor, model, index);
    emit dataChanged();
    break;
  default: {
      QLineEdit * w=qobject_cast<QLineEdit *>(editor);
      if(!w) return;
      if(w->isModified() && model->data(index)!=w->text()) {
        model->setData(index, w->text());
        emit dataChanged();
      }
    }
    break;
  }
}

} // namespace SciFigs
