/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-08-14
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGEWIDGET_H
#define IMAGEWIDGET_H

#include "GraphicObject.h"

namespace SciFigs {

class AxisWindow;
class GraphicObjectProperties;

class SCIFIGS_EXPORT ImageWidget :  public GraphicObject
{
  Q_OBJECT
  // Compatibility
  Q_PROPERTY(QString imageFormat READ dummyPropertyString WRITE setDummyProperty STORED false)
  Q_PROPERTY(bool fixedXYRatio READ dummyPropertyInt WRITE setConstantWidthHeightRatio STORED false)

  Q_PROPERTY(QString imageFile READ fileName WRITE setFileName SCRIPTABLE true)
public:
  ImageWidget(QWidget * parent=nullptr);
  ~ImageWidget();

  virtual const QString& xml_tagName() const {return xmlImageWidgetTag;}
  static const QString xmlImageWidgetTag;

  QString fileName() const {return _fileName;}
  void setFileName(QString s) {_fileName=s;}

  void loadImage();

  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);
public slots:
  virtual void showProperties() {GraphicObject::showProperties(_category);}
private:
  QImage _trueImage;
  QPixmap _pixmap;
  QString _fileName;
  static uint _category, _tabLink;

  virtual bool xml_polish(XML_POLISH_ARGS);
  virtual void resizeEvent(QResizeEvent *);
  virtual void paintEvent(QPaintEvent * e);
  virtual void updateMask();
  virtual void paint(QPainter& p, double dotpercm,int w, int h, bool mask);
  virtual void update();
};

} // namespace SciFigs

#endif // IMAGEWIDGET_H
