/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-11
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GraphicObject.h"
#include "FontScales.h"

namespace SciFigs {

  /*!
    \class FontScales FontScales.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void FontScales::add(GraphicObject * obj, double value)
  {
    TRACE;
    QHash<GraphicObject *, QVector<double>>::iterator it;
    it=_values.find(obj);
    if(it!=_values.end()) {
      it.value().append(value);
    } else {
      QVector<double> vect(1);
      vect[0]=value;
      _values.insert(obj, vect);
    }
  }

  const QVector<double>& FontScales::values(GraphicObject * obj) const
  {
    TRACE;
    QHash<GraphicObject *, QVector<double>>::const_iterator it;
    it=_values.find(obj);
    if(it!=_values.end()) {
      return it.value();
    }
    ASSERT(false);
  }

} // namespace SciFigs

