/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONLIMITLAYER_H
#define DISPERSIONLIMITLAYER_H

#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT DispersionLimitLayer : public LineLayer
{
  Q_OBJECT
public:
  DispersionLimitLayer(AxisWindow * parent);
  ~DispersionLimitLayer();

  void setFrequencySampling(const SamplingParameters& fparam);
  void setConstantWaveNumber(int curveIndex, double k);
  void setConstantWaveLength(int curveIndex, double lambda);

  void addArrayLimits();
public slots:
  void setArrayKmin(double k);
  void setArrayKmax(double k);
  void setArraySize(double s);
  void setLambdaLegend(const Legend& l);
private:
  void updateFrequencySampling();
  void updateArraySize();
  Curve<Point>& curve(int index);

  SamplingParameters _freqSamp;
  double _arraySize;
  Legend _lambdaLegend;
};

} // namespace QGpGuiWave

#endif // DISPERSIONLIMITLAYER_H
