/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-04
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H

#include "ui_MessageBox.h"
#include "Dialog.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT MessageBox : public Dialog, protected Ui::MessageBoxd
{
  Q_OBJECT
public:
  MessageBox(QWidget * parent=nullptr);
  ~MessageBox() {}

  void setMessage(QString t);
  void setSeverity(Message::Severity sev);
  void addAgainOption();
  bool showAgain();
  void setButton(int index, QString but);

  Message::Answer answer() {return _answer;}
private slots:
  void on_buttons_clicked(QAbstractButton * but);
private:
  QPushButton * _buttons[3];
  QCheckBox * again;
  Message::Answer _answer;
};

} // namespace QGpGuiTools

#endif // MESSAGEBOX_H
