/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-25
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GUIGLOBAL_H
#define GUIGLOBAL_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  QGPGUITOOLS_EXPORT void setWidgetColor(QWidget * w, QColor c);
  QGPGUITOOLS_EXPORT QColor widgetColor(QWidget * w);

  inline void guiColor(const Color &c, QColor& gc)
  {
    // No function call inside QColor::setRgba, only inline masks for the conversion
    gc.setRgba(c.rgba());
  }

  inline void coreColor(const QColor &gc, Color& c)
  {
    c.setRgb(gc.rgba());
  }

} // namespace QGpGuiTools


#endif // GUIGLOBAL_H
