/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-17
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CHECKCOMBOBOXMODEL_H
#define CHECKCOMBOBOXMODEL_H

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT CheckComboBoxModel : public QAbstractListModel
  {
    Q_OBJECT
  public:
    CheckComboBoxModel(QObject * parent);
    ~CheckComboBoxModel();

    virtual int rowCount(const QModelIndex& parent=QModelIndex()) const;
    virtual int columnCount(const QModelIndex& parent=QModelIndex()) const;
    virtual QVariant data(const QModelIndex& index, int role) const;
    virtual bool setData(const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
    virtual Qt::ItemFlags flags (const QModelIndex &) const;

    void addItems(const QStringList& items);
    void setCurrentItems(const QString& items);
    void toggleItem(int index);
    QString currentText() const;
  signals:
    void valueChanged();
  private:
    QList<QPair<QString, bool> > _items;
  };

} // namespace QGpGuiTools

#endif // CHECKCOMBOBOXMODEL_H
