/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGESCALINGPOINT_H
#define IMAGESCALINGPOINT_H

#include <QGpGuiTools.h>

#include "ui_ImageScalingPoint.h"
#include "ImageLayer.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT ImageScalingPoint : public QWidget, private Ui::ImageScalingPoint
  {
    Q_OBJECT
  public:
    ImageScalingPoint(QWidget * parent=nullptr);
    ~ImageScalingPoint();

    void setReferences(const QList<ImageLayer::ReferencePoint>& ref);
    const QList<ImageLayer::ReferencePoint>& references() const {return _references;}
  public slots:
    void add(QPoint p);
  private slots:
    void on_applyCancelButton_clicked(QAbstractButton * button);
    void on_applyCancelButton_rejected();
    void on_addPoint_clicked();
    void on_deletePoint_clicked();
    void on_pointTable_cellChanged (int row, int column);
    void on_importCoordinates_clicked();
    void on_exportCoordinates_clicked();
  signals:
    void apply();
  private:
    void setScaling();
    void createItem(int index);

    UtmZone _utmZone;
    QList<ImageLayer::ReferencePoint> _references;
  };

} // namespace QGpGuiMath

#endif // IMAGESCALINGPOINT_H
