/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "CurveSelector.h"
#include "CurveSelectorItem.h"

namespace QGpGuiMath {

/*!
  \class CurveSelector CurveSelector.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CurveSelector::CurveSelector(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
  selector->setView(curveList);
  CurveSelectorItem * model=new CurveSelectorItem(this);
  curveList->setModel(model);
  curveList->setSelectionMode(QAbstractItemView::ExtendedSelection);
  curveList->setEditTriggers(QAbstractItemView::NoEditTriggers);
  curveList->setHeaderHidden(true);
}

void CurveSelector::addGroup(const QString& g)
{
  TRACE;
  CurveSelectorItem * m=static_cast<CurveSelectorItem *>(curveList->model());
  m->addGroup(g);
}

void CurveSelector::addCurve(CurveProperties * p)
{
  TRACE;
  CurveSelectorItem * m=static_cast<CurveSelectorItem *>(curveList->model());
  m->addCurve(p);
}

void CurveSelector::selectAll()
{
  curveList->selectAll();
}

QList<CurveProperties *> CurveSelector::selectedCurves()
{
  CurveSelectorItem * m=static_cast<CurveSelectorItem *>(curveList->model());
  return m->curves(curveList->selectionModel()->selectedRows());
}

} // namespace QGpGuiMath
