/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TaskWorker.h"
#include "TaskManager.h"

namespace QGpCoreTools {

  /*!
    \class TaskWorker TaskWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  TaskWorker::TaskWorker()
    : LoopWorker()
  {
    TRACE;
    _taskManager=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  TaskWorker::~TaskWorker()
  {
    TRACE;
  }

  void TaskWorker::run(int)
  {
    AbstractTask * t;
    while(!terminated()) {
      t=_taskManager->nextFreshTask();
      if(!t) {
        break;
      }
      process(t);
    }
    _taskManager->purgeTasks();
    while(!terminated()) {
      t=_taskManager->nextTask();
      if(!t) {
        break;
      }
      process(t);
    }
    _taskManager->purgeTasks();
    mergeResults();
  }

} // namespace QGpCoreTools

