/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-22
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLEFILTER_H
#define SAMPLEFILTER_H

#include <QGpCoreStat.h>

class SampleFilter
{
public:
  SampleFilter();
  ~SampleFilter();

  class QGPCORESTAT_EXPORT Sample : public Histogram2D::Sample
  {
  public:
    Sample() : Histogram2D::Sample() {_time=0.0; _frequency=0.0; _noise=0.0; _power=0.0;}
    Sample(const Sample& s) : Histogram2D::Sample(s) {_time=s._time; _frequency=s._frequency; _noise=s._noise; _power=s._power;}

    bool read(const QString& line, int xColumn=0, int yColumn=1,
              int noiseColumn=2, int powerColumn=3, int validColumn=-1);

   double time() const {return _time;}
   double frequency() const {return _frequency;}
   double noise() const {return _noise;}
   double power() const {return _power;}
  private:
    double _time;
    double _frequency;
    double _noise;
    double _power;
  };

  void append(const Sample& s) {_samples.append(s);}
  int count() const {return _samples.count();}
  void filterPower(double relThreshold);
  void filterNoise(double threshold);
  void filterXMinimum(double threshold);
  void filterXMaximum(double threshold);
  void filterYMinimum(double threshold);
  void filterYMaximum(double threshold);
  QVector<Histogram2D::Sample> samples() const;
private:
  void selectPower(int beginIndex, int endIndex, double minPower);
  static bool lessThan(const Sample& s1, const Sample& s2);
  QVector<Sample> _samples;
};

#endif // SAMPLEFILTER_H

