/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-06-11
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LIKELIHOOD_H
#define LIKELIHOOD_H

#include <DinverCore.h>

#include "QGpCoreStatDLLExport.h"
#include "GaussianMixtureParameters.h"
#include "Densities.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT Likelihood : public AbstractForward, public Densities
  {
  public:
    Likelihood(const GaussianMixtureParameters * p);
    Likelihood(const Likelihood& o);
    ~Likelihood();

    double minimumValue() const {return _minimumValue;}
    void setMinimumValue(double m);

    double maximumValue() const {return _maximumValue;}
    void setMaximumValue(double m);

    int sampleCount() const {return _sampleCount;}
    void setSampleCount(int s);
    void setSample(int index, double val) {_samples[index]=val;}

    bool setInversionParameters();

    virtual AbstractForward * clone() const;
    virtual double misfit(bool& ok);
    virtual int maximumThreadCount() const {return INT_MAX;}

    void setValues(const int * values);
  private:
    void parametersToDensities();
    void parametersToWeights(int firstWeightIndex);
    void setWeightParameters();

    const GaussianMixtureParameters * _parameters;
    double _minimumValue, _maximumValue;

    int _sampleCount;
    double * _samples;
  };

} // namespace QGpCoreStat

#endif // LIKELIHOOD_H

