/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-24
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GaussianMixtureParameters.h"

namespace QGpCoreStat {

  /*!
    \class GaussianMixtureParameters GaussianMixtureParameters.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GaussianMixtureParameters::GaussianMixtureParameters()
    : AbstractParameters()
  {
    TRACE;
    _inversionType=MeanOnly;
    _relativeError=0.1;
    _absoluteError=0.0;
    _modeCount=4;
    _verbose=false;
    _kmin=0.0;
    _kmax=0.0;
  }

  /*!
    Description of destructor still missing
  */
  GaussianMixtureParameters::GaussianMixtureParameters(const GaussianMixtureParameters& o)
    : AbstractParameters(o)
  {
    TRACE;
    _inversionType=o._inversionType;
    _relativeError=o._relativeError;
    _absoluteError=o._absoluteError;
    _modeCount=o._modeCount;
    _verbose=o._verbose;
    _kmin=o._kmin;
    _kmax=o._kmax;
  }

  AbstractParameters * GaussianMixtureParameters::clone() const
  {
    TRACE;
    return new GaussianMixtureParameters(*this);
  }

  void GaussianMixtureParameters::setInversionType(QString t)
  {
    TRACE;
    t=t.toLower();
    if(!t.isEmpty()) {
      switch(t[0].unicode()) {
      case 'f':
        _inversionType=Full;
        break;
      case 'm':
        _inversionType=MeanOnly;
        break;
      default:
        App::log(tr("Unrecognized inversion type: '%1'\n").arg(t) );
        break;
      }
    }
  }

  double GaussianMixtureParameters::absoluteError(double mean) const
  {
    TRACE;
    if(_absoluteError>0.0) {
      return _absoluteError;
    } else {
      return mean*_relativeError;
    }
  }

} // namespace QGpCoreStat

