/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Point1D.h"

namespace QGpCoreMath {

/*!
  \class Point1D Point1D.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  \fn Point1D::Point1D()
  Description of constructor still missing
*/

/*!
  Returns the point as a string with space separation between coordinates.
  \a precision is the number of significant digits. \a format is 'g' or 'f'.
*/
QString Point1D::toString(int precision, char format) const
{
  TRACE;
  return QString::number(_x, format, precision);
}

bool Point1D::fromString(const StringSection& str)
{
  TRACE;
  if(str.isValid()) {
    _x=str.toDouble();
    return true;
  } else {
    return false;
  }
}

} // namespace QGpCoreMath
