/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-12-19
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PermutationVector.h"

namespace QGpCoreMath {

  /*!
    \class PermutationVector PermutationVector.h
    \brief To perfom permutations in a matrix

    \a Matrix::sortedRows(), Matrix::sortedColumns()
  */

  /*!
    Returns a permutation vector that can de-sort matrix sorted so far.
  */
  PermutationVector PermutationVector::inverted()
  {
    int n=count();
    PermutationVector tmp(n);
    for(int i=0; i<n; i++) {
      tmp.setNewIndex(newIndex(i), i);
    }
    return tmp;
  }

  QString PermutationVector::toString() const
  {
    QString str;
    int n=count();
    for(int i=0; i<n; i++) {
      str+=QString("%1 --> %2\n").arg(i, 3, 10, QChar(' ')).arg(newIndex(i), 3, 10, QChar(' '));
    }
    return str;
  }

} // namespace QGpCoreMath
