/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXMATRIX_H
#define COMPLEXMATRIX_H

#include "Matrix.h"
#include "MatrixIterator.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class DoubleMatrix;

  class QGPCOREMATH_EXPORT ComplexMatrix: public Matrix<Complex>
  {
  public:
    ComplexMatrix() : Matrix<Complex>() {}
    ComplexMatrix(int ndim) : Matrix<Complex>(ndim, ndim) {}
    ComplexMatrix(int nrow, int ncol) : Matrix<Complex>(nrow, ncol) {}
    ComplexMatrix(const Matrix<Complex> m) : Matrix<Complex>(m) {}
    ComplexMatrix(const ComplexMatrix& m) : Matrix<Complex>(m) {}

    void operator*=(double v);
    void operator*=(const ComplexMatrix& m) {Matrix<Complex>::operator*=(m);}
    void operator*=(const Complex& v) {Matrix<Complex>::operator*=(v);}
    ComplexMatrix dotMultiply(const ComplexMatrix& m) const {return Matrix<Complex>::dotMultiply(m);}
    ComplexMatrix dotMultiply(const DoubleMatrix& m) const;

    void rand();
    ComplexMatrix conjugate() const;
    bool invert();
    bool choleskyInvert();
    bool singularValue(QVector<double>& sigma, ComplexMatrix& u, ComplexMatrix& vt) const;
    bool invert(const ComplexMatrix& u, const QVector<double>& sigma, const ComplexMatrix& vt);
    bool pseudoInvert(const ComplexMatrix& u, const QVector<double>& sigma, const ComplexMatrix& vt);
    QString toUserString(int precision=6, char format='g') const;
  private:
    void hermitianUpToLow();
  };

  QGPCOREMATH_EXPORT QTextStream& operator<<(QTextStream& s, const ComplexMatrix& m);

} // namespace QGpCoreMath

#endif // COMPLEXMATRIX_H
