/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-05-22
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "CompatReportFactory.h"
#include "CompatAutocorrReport.h"
#include "CompatRefraReport.h"

namespace QGpCompatibility {

CompatInversionReport * CompatReportFactory::open(QString reportFile)
{
  TRACE;
  CompatInversionReport * test=new CompatInversionReport(false,reportFile);

  CompatInversionReport::BlockType reportType=test->reportType();
  if(reportType==CompatInversionReport::AutocorrGoal) {
    delete test;
    test=new CompatAutocorrReport(false,reportFile);
  }
  else if(reportType==CompatInversionReport::RefraGoal) {
    delete test;
    test=new CompatRefraReport(false,reportFile);
  }
  return test;
}

} // namespace QGpCompatibility
