/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALCURVES_H
#define COMPATMODALCURVES_H

#include <QGpCoreMath.h>

#include "CompatDataPoint.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

typedef QVector<CompatVDataPointVector> CompatModalDataVector;

class QGPCOMPATIBILITY_EXPORT CompatModalCurves :
      protected CompatModalDataVector, public XMLClass
{
public:
  virtual ~CompatModalCurves() {}

  void operator=(const CompatModalCurves& o);

  virtual void setNModes(int nm);
  void setNOmegas(int nf);

  int nModes() const {return count();}
  int nOmegas() const {return (nModes() > 0) ? ( *this) [ 0 ].count() : 0;}

  CompatVDataPointVector& mode(int imode) {return operator[] (imode);}
  const CompatVDataPointVector& mode(int imode) const {return operator[] (imode);}

  void setInvalidValue(double val) {_invalidValue=val;}
  const double& invalidValue() const {return _invalidValue;}

  void resetValues();
  void resetValues(int im);
  int validValues(int im) const;

  void addInvalid();
  void insertInvalidAt(int i);
  void insertModes(int atMode, int nNewModes);
  
  QVector<double> * meanVector(int im) const;
  QVector<double> * stddevVector(int im) const;
  QVector<double> * weightVector(int im) const;
protected:
  double _invalidValue;
protected:
  CompatVDataPointVector invalidMode();

  virtual const QString& xml_tagName() const {return xmlModalCurvesTag;}
  static const QString xmlModalCurvesTag;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};

QGPCOMPATIBILITY_EXPORT QDataStream& operator<< (QDataStream& s, const CompatModalCurves& p);
QGPCOMPATIBILITY_EXPORT QDataStream& operator>> (QDataStream& s, CompatModalCurves& p);

} // namespace QGpCompatibility

#endif // COMPATMODALCURVES_H
