/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-05-20
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/
#include <math.h>
#include <qglobal.h>

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "CompatEllipticityData.h"
#include "CompatDispersion.h"

namespace QGpCompatibility {

#define twopi (2*M_PI)

ModalCurve CompatEllipticityData::curve(int iMode)
{
  TRACE;
  ModalCurve c=CompatMultiModalData::curve(iMode);
  int n=CompatMultiModalFrequency::_omegasCount;
    for(int i=0;i<n;i++) {
    c[i].setX(_omegas[i]);
  }
  return c;
}

void CompatEllipticity::resetValues()
{
  TRACE;
  for(int mode=0; mode<_modesCount;mode++) {
      double * values=_values[mode];
      for(int i=0;i<_omegasCount;i++) values[i]=CompatELLIPTICITY_INVALID_VALUE;
    }
}

CompatEllipticityData::CompatEllipticityData() :
 CompatEllipticity(),
 CompatMultiModalData() 
{
  TRACE;
    _f0=0;
    _devf0=0;
}

CompatEllipticityData::CompatEllipticityData(int modesCount,int omegasCount) :
 CompatEllipticity(modesCount, omegasCount),
 CompatMultiModalData(modesCount, omegasCount)
{
  TRACE;
    _f0=0;
    _devf0=0;
}

CompatEllipticityData::CompatEllipticityData(const CompatEllipticityData * o,int modesCount) :
 CompatEllipticity(o, modesCount),
 CompatMultiModalData(o, modesCount,CompatELLIPTICITY_INVALID_VALUE)
{
  TRACE;
    _f0=0;
    _devf0=0;
}
  
CompatEllipticityData::CompatEllipticityData(const CompatEllipticity * o) :
 CompatEllipticity(o),
 CompatMultiModalData(o) 
{
  TRACE;
    _f0=0;
    _devf0=0;
}

void CompatEllipticityData::f0ToReport(QDataStream& s)
{
  TRACE;
  s << _f0;
  s << _devf0;  
}

void CompatEllipticityData::reportToF0(QDataStream& s)
{
  TRACE;
  s >> _f0;
  s >> _devf0;
}

} // namespace QGpCompatibility
