/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-05-19
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONDATA_H
#define DISPERSIONDATA_H

#include "QGpCompatibilityDLLExport.h"
#include "CompatDispersion.h"
#include "CompatMultiModalData.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatDispersionData : public CompatDispersion, public CompatMultiModalData
{
public:
  /// default constructor
  CompatDispersionData():
  CompatDispersion(), CompatMultiModalData() {}
  /// Allocates an empty structure
  CompatDispersionData(int modesCount,int omegasCount):
      CompatDispersion(modesCount, omegasCount),
  CompatMultiModalData(modesCount, omegasCount) {}
  /// Allocates an empty structure based on an existing one with another number of modes
  CompatDispersionData(const CompatDispersionData * o,int modesCount):
      CompatDispersion(o, modesCount),
  CompatMultiModalData(o, modesCount,0) {}
  /// Set the values o as the measurements
  CompatDispersionData(const CompatMultiModalCurves * o):
      CompatDispersion(o),
  CompatMultiModalData(o) {}
  void valuesToData() {CompatMultiModalData::valuesToData(this);}
  void valuesToData(CompatMultiModalCurves * o)
  {CompatMultiModalData::valuesToData(o);}
  // Compatibility with new framework
  ModalCurve curve(int iMode);
  /** Calculate the Root Mean Square for the current calculated dispersion curve between indexes
    iMin and iMax */
  double misfit(int iMin, int iMax, FILE * flog);
  /// Calculate the Root Mean Square for the current calculated dispersion curve
  double misfit(FILE * flog)
  {
    return misfit(0,CompatMultiModalFrequency::_omegasCount-1,flog);
  }
  /** Calculate the Root Mean Square for the current calculated dispersion curve using
  the mode that matches best the the data fundamental curve (taken as the effictive apparent velocity) */
  double closestModeMisfit(bool strictModeJumping, FILE * flog);
  /** the measurements are read from a file of the Herrmann disp.d format:
  1st line :   IUNIT (not used here) IFRPER (0 if period, 1 if frequency)
  Other lines: ILVRY (1=Love,2=Rayleigh) IPORG(unused) IMODE FRPER VAL DVAL(unused)
  */
  //void loadHerrmann(char * filename);
  /// Export in a file readable by Herrmann SURF
  //void saveHerrmann(char * fileName);
  void convertStddev();
  double minDataFrequency();
  double maxDataFrequency();
  QVector<double> * groupSlowness(int iMode);
/*protected:
  virtual const QString& xml_tagName() const {return xmlDispersionDataTag;}
  static const QString xmlDispersionDataTag;
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(CompatStringSection& propertyName,
                               CompatStringSection& content);*/
};

} // namespace QGpCompatibility

#endif // COMPATDISPERSIONDATA_H
