/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-29
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PEAKEDITOR_H
#define PEAKEDITOR_H

#include <HVCore.h>

#include "ui_PeakEditor.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class AbstractPeakModel;

  class HVGUI_EXPORT PeakEditor : public QWidget, private Ui::PeakEditor
  {
    Q_OBJECT
  public:
    PeakEditor(QWidget * parent=nullptr);
    ~PeakEditor();

    void setModel(AbstractPeakModel * m);
  private slots:
    void on_addButton_clicked();
    void on_adjustButton_clicked();
    void on_removeButton_clicked();
    void on_saveButton_clicked();
  signals:
    void touched();
  };

} // namespace HVGui

#endif // PEAKEDITOR_H
