/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-27
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CATEGORYGROUPITEM_H
#define CATEGORYGROUPITEM_H

#include <HVGui.h>

#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT CategoryGroupItem : public SignalGroupItem
  {
  public:
    CategoryGroupItem(QObject * parent=nullptr) : SignalGroupItem(parent) {}
    void setSignals(const QList<AbstractStation *>& stations);

    virtual Qt::ItemFlags flags(const QModelIndex&) const;

    static bool belongsTo(AbstractStation * stat, const AbstractSignalGroup * g);
  private:
    QSet<Signal *> _signals;
  };

} // namespace HVGui

#endif // CATEGORYGROUPITEM_H
