/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-06-22
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTPEAKMODEL_H
#define ABSTRACTPEAKMODEL_H

#include <QtGui>

#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT AbstractPeakModel : public QAbstractTableModel
  {
  public:
    AbstractPeakModel(QObject * parent=nullptr);
    ~AbstractPeakModel();

    virtual void add(double min, double max)=0;
    virtual void adjust(int index, double min, double max)=0;
    virtual void remove(int index)=0;
    virtual void save(QTextStream& s, int index)=0;

    Qt::ItemFlags flags (const QModelIndex & index) const;
  };

} // namespace HVGui

#endif // ABSTRACTPEAKMODEL_H

