/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-17
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SpectrumStationSignals.h"
#include "HVParameters.h"

namespace HVCore {

/*!
  \class SpectrumStationSignals SpectrumStationSignals.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool SpectrumStationSignals::setProcessed(const StationProcessSignals * from,
                                          const TimeRange& tw, const AbstractParameters * param)
{
  TRACE;
  const HVParameters * specParam=static_cast<const HVParameters *>(param);
  if(!copyOriginalSignal(0, tw, from)) {
    return false;
  }
  DoubleSignal *& psig=processed(0);
  psig->subtractValue();
  psig->taper(0.0, tw.lengthSeconds(), specParam->tapering());
  // Correction factor required for PSD. See Mc Namara 2004
  TaperDelegate window(&specParam->tapering());
  double factor=window.correctionFactor(0.0, tw.lengthSeconds(), psig->samplingFrequency());
  App::log(1, tr("PSD taper correction factor: %1\n").arg(factor, 0, 'f', 6));
  psig->multiply(factor);
  psig->fastFourierTransform(DoubleSignal::Spectrum);
  _spectrum=psig->spectrumAmplitudeCurve();
  _spectrum.smooth(specParam->sampling(), specParam->smoothing());
  return true;
}

} // namespace HVCore
