/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-20
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SpectrumStation.h"
#include "CurveResults.h"
#include "SpectrumStationSignals.h"
#include "HVParameters.h"

namespace HVCore {

  /*!
    \class SpectrumStation SpectrumStation.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SpectrumStation::SpectrumStation(StationSignals * sig)
    : AbstractStation(new StationProcessSignals(sig))
  {
    TRACE;
  }

  bool SpectrumStation::save(int, QDir outputDir, const HVParameters& param)
  {
    TRACE;
    Signal * sig=_signals->originalSignals()->firstValidSignal();
    ASSERT(sig);
    QString fileName=sig->name()+"_"+Signal::componentLetter(sig->component());
    fileName=outputDir.absoluteFilePath(fileName+".spec");
    return _results[0]->save(fileName, log(param));
  }

  StationProcessSignals * SpectrumStation::createProcessSignals()
  {
    return new SpectrumStationSignals;
  }

  AbstractResults * SpectrumStation::createResults()
  {
    AbstractResults * r=new CurveResults(this);
    r->setName(originalSignals()->nameComponent());
    connect(r, SIGNAL(colorsToChange(const QVector<int>*, const Color&)),
            this, SLOT(changeColors(const QVector<int>*, const Color&)));
    return r;
  }

  void SpectrumStation::process(StationProcessSignals * proc, int windowIndex, const HVParameters * param) const
  {
    TRACE;
    SpectrumStationSignals * spectrumProc=static_cast<SpectrumStationSignals *>(proc);
    const TimeWindow& r=windowAt(windowIndex);
    if(spectrumProc->setProcessed(_signals, r, param)) {
      _results[0]->setWindow(windowIndex, r.lengthSeconds(), spectrumProc->spectrum());
      _results[0]->setWindowColor(windowIndex, r.color());
    }
  }

} // namespace HVCore

