/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALSPROPERTIES_H
#define SIGNALSPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_SignalsProperties.h"
#include "GeopsyGuiDLLExport.h"
#include "SignalLayer.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT SignalsProperties : public PropertyWidget, public Ui::SignalsProperties
{
  Q_OBJECT
public:
  SignalsProperties(QWidget* parent=0);
  ~SignalsProperties();

  enum Properties {ColoredSection, IsSpectrum, Wiggle, VariableArea,
                   Normalize, NormalizeValue, ClipMode, ClipValue, Overlap, Offset,
                   YAxis, TimeScale, TimeRange, AroundPickName, BeforePickDelay,
                   AfterPickDelay, CustomRange};

  void setCurrentLayer(SignalLayer * l);
  virtual void setWidgets();

  static int normalize2item(SignalLayer::Normalize n);
  static SignalLayer::Normalize item2normalize(int index);
  static int clip2item(SignalLayer::Clip n);
  static SignalLayer::Clip item2clip(int index);
  static int offset2item(SignalLayer::Offset n);
  static SignalLayer::Offset item2offset(int index);
  static int yAxis2item(SignalLayer::YAxis n);
  static SignalLayer::YAxis item2yAxis(int index);
  static int timeRange2item(SignalLayer::TimeRange n);
  static SignalLayer::TimeRange item2timeRange(int index);
  static int timeScale2item(SignalLayer::TimeScale n);
  static SignalLayer::TimeScale item2timeScale(int index);
private:
  virtual PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
  virtual bool connectCustomWidget(PropertyValue & );
  virtual QVariant customWidgetValue(PropertyValue & );
  virtual bool setCustomWidget(PropertyValue &  p);
public slots:
  void on_coloredSection_clicked();
  void on_normalize_currentIndexChanged(int);
  void on_clipMode_currentIndexChanged(int);
  void on_defaultPaletteValues_clicked();
  void on_timeRange_currentIndexChanged(int);
  void on_setSignalColors_clicked();
private slots:
  void commitSignalColors();
signals:
  void setColorMapValues(ColorMap pal);
private:
  SignalLayer * _currentLayer;
  LegendProperties * _signalColorEditor;
};

} // namespace GeopsyGui

#endif // SIGNALSPROPERTIES_H
