/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-09-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <math.h>

#include "MorletParameterWidget.h"

namespace GeopsyGui {

  /*!
    \class MorletParameterWidget MorletParameterWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  MorletParameterWidget::MorletParameterWidget(QWidget * parent)
      : QWidget(parent)
  {
    TRACE;
    setupUi(this);
    connect(morletM, SIGNAL(valueChanged(double)), this, SLOT(showResolution()));
    connect(morletFi, SIGNAL(valueChanged(double)), this, SLOT(showResolution()));
    showResolution();
  }

  void MorletParameterWidget::updateAllFields()
  {
    TRACE;
    showResolution();
  }

  void MorletParameterWidget::showResolution()
  {
    TRACE;
    MorletParameters param;
    getParameters(param);
    static const QString str("<span style=\"font-family:'Symbol';\">D</span>T=%1, <span style=\"font-family:'Symbol';\">D</span>F=%2");
    resolutionResults->setText(str.arg(param.deltaT()).arg(param.deltaF()));
    emit parametersChanged();
  }

  void MorletParameterWidget::getParameters(MorletParameters& param)
  {
    TRACE;
    param.setFi(morletFi->value());
    param.setM(morletM->value());
  }

  void MorletParameterWidget::setParameters(const MorletParameters& param)
  {
    TRACE;
    morletFi->setValue(param.fi());
    morletM->setValue(param.m());
  }

} // namespace GeopsyGui
