/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYGUIINTERFACE_H
#define GEOPSYGUIINTERFACE_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class AbstractToolWidget;

  class GEOPSYGUI_EXPORT GeopsyGuiInterface : public GeopsyCoreInterface
  {
    Q_OBJECT
  public:
    virtual void createToolActions(QObject * /*toolFactory*/) {}
    virtual QList<QAction *> createImportActions(QWidget * /* parent */) const {return QList<QAction *>();}
    virtual AbstractToolWidget * createTool(int /*id*/, QWidget * /*wsParent*/) const {return 0;}

    virtual void addPreferenceTab(QTabWidget * parent);
    virtual void setPreferences();

    virtual void setHelp(ApplicationHelp * h);

    int slotCount() const {return _actions.count();}
    int slotOf(QAction * a) {return _actions.indexOf(a);}
    QAction * action(int slot) const {return _actions[slot];}
    QString slotText(int id) {return _actions[id]->text();}
    void addActions(QWidget * w) const;
  protected:
    void addAction(QAction * a) {_actions << a;}
  private:
    QVector<QAction *> _actions;
  };

} // namespace GeopsyGui

#endif // GEOPSYGUIINTERFACE_H
