/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-17
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUPFOLDER_H
#define SIGNALGROUPFOLDER_H

#include "AbstractSignalGroup.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SignalGroupFolder: public AbstractSignalGroup
  {
  public:
    SignalGroupFolder(AbstractSignalGroup * parent=nullptr);

    virtual const QString& xml_tagName() const {return xmlSignalGroupFolderTag;}
    static const QString xmlSignalGroupFolderTag;

    virtual bool readOnly() const {return _readOnly;}
    virtual bool readOnlyChildren() const {return _readOnlyChildren;}
    virtual bool stored() const {return _stored;}

    void setReadOnly(bool ro) {_readOnly=ro;}
    void setReadOnlyChildren(bool ro) {_readOnlyChildren=ro;}
    void setStored(bool st) {_stored=st;}
  private:
    uint _readOnly:1;
    uint _stored:1;
    uint _readOnlyChildren:1;
    uint _unused:29;
  };

} // namespace GeopsyCore

#endif // SIGNALGROUPFOLDER_H
