/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-18
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SHARKHEADER_H
#define SHARKHEADER_H

#include <QGpCoreMath.h>

#include "SignalFileFormat.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SharkHeader
  {
  public:
    SharkHeader(SignalFileFormat::Format f);

    bool parseLine(const QString& line);
    bool isValid(const QFile& f);

    SignalFileFormat::Format format;
    int channelCount;
    int sampleCount;
    int recordDuration;
    QString fileName;
    QString originalFileName;
    DateTime startTime;
    double samplingFrequency;
    QString debugSamplingFrequency; // Bug reported by Bertrand Guillier for some Mac OS 10.6
    double gain;
    double conversionFactor;
    QString comments;
    Point utmPosition;
    UtmZone utmZone;
    Version miniSharkVersion;
  };

} // namespace GeopsyCore

#endif // SHARKHEADER_H

