/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-03
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SHAREDMETADATA_H
#define SHAREDMETADATA_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class MetaData;
class Signal;

class GEOPSYCORE_EXPORT SharedMetaData : public XMLClass, public QVector<MetaData *>
{
public:
  SharedMetaData() {}
  SharedMetaData(const SharedMetaData& o);
  virtual ~SharedMetaData() {}

  virtual const QString& xml_tagName() const {return xmlSharedMetaDataTag;}
  static const QString xmlSharedMetaDataTag;

  void add(MetaData * d) {QVector<MetaData *>::append(d);}
  void add(Signal * sig);

  void setIds();
  void xml_writeLinks(XMLStream& s) const;
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  int _lastId;
};

} // namespace GeopsyCore

#endif // SHAREDMETADATA_H
