/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-09
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NORMALIZATIONPARAMETERS_H
#define NORMALIZATIONPARAMETERS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT NormalizationParameters: public AbstractParameters
{
public:
  NormalizationParameters();
  NormalizationParameters(const NormalizationParameters& o);

  virtual AbstractParameters * clone() const {return new NormalizationParameters(*this);}

  enum Type {None, SurfaceAttenuation, VolumeAttenuation, MaximumAmplitude, SpectrumEnergy};

  void setType(Type t);
  void setType(const QString& t);
  Type type() const {return _type;}
  QString typeString() const;

  void setFrequencyRange(double min, double max);
  double minimumFrequency() const {return _fmin;}
  double maximumFrequency() const {return _fmax;}

  virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
protected:
  virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
  virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
private:
  Type _type;
  double _fmin, _fmax;
};

} // namespace GeopsyCore

#endif // NORMALIZATIONPARAMETERS_H
