/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-03-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALFORMATREADER_H
#define ASCIISIGNALFORMATREADER_H

#include <QGpCoreTools.h>

#include "AsciiSignalFormat.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT AsciiSignalFormatReader : public Thread
{
  Q_OBJECT
public:
  AsciiSignalFormatReader(QObject * parent=nullptr);
  ~AsciiSignalFormatReader();

  void setFileName(const QString& f);
  void setFormat(const AsciiSignalFormat& f);

  const AsciiSignalFormat& format() const {return _format;}
  const QString& header() const {return _header;}

  void stop();
signals:
  void dataChanged();
private:
  virtual void run();

  QAtomicInt _stopRequest;
  QString _fileName, _header;
  AsciiSignalFormat _format;
};

} // namespace GeopsyCore

#endif // ASCIISIGNALFORMATREADER_H
