/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  DinverDCGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-01-18
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONVIEWER_H
#define DISPERSIONVIEWER_H

#include <QGpCoreWave.h>
#include "DCModelViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT DispersionViewer : public DCModelViewer
{
  Q_OBJECT
public:
  DispersionViewer(QWidget * parent=nullptr);
  ~DispersionViewer();

  virtual void setMode(const Mode& m);
protected:
  virtual void setTitles(int i);
  virtual bool hasCurves(DCReportBlock& dcBlock, int version);
  virtual void setSampleCount(DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual void setTarget(const TargetList * tl);
  virtual AbstractLine * targetReferenceLine() const;

  bool seekMode(DCReportBlock& dcBlock);
  Mode _mode;
};

} // namespace DinverDCGui

#endif // DISPERSIONVIEWER_H
